<?php

/**
 * Plugin Name: Backup Migration – Autologin
 * Description: Autologin script for Staging sites created with Backup & Migration plugin
 *      Author: Migrate
 *  Author URI: https://backupbliss.com/
 *  Plugin URI: https://backupbliss.com
 * Text Domain: backup-backup
 *     Version: 1.0.0
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// Namespace
namespace BMI\Plugin\Staging;

// Exit on direct access
if (!defined('ABSPATH')) {
  exit;
}

/**
 * Backup & Migration plugin
 * Must-use plugin script
 * It should be used only on
 * Staging sites
 */
class BMI_Passwordless_Login {

  /* AUTH DETAILS START */
  private $userIP = '%%user_ip%%';
  private $userID = '%%user_id%%';
  private $secretPassword = '%%secret_password%%';
  /* AUTH DETAILS END */

  /**
   * __construct - Integration Initializer
   *
   * @return @self
   */
  function __construct() {

    // Password less login module
    add_action('wp_loaded', [$this, 'refreshPermalink'], -15);
    add_action('wp_loaded', [$this, 'loginPageRedirectionWhileLogged'], -20);
    add_action('wp_loaded', [$this, 'passwordLessLoginModule'], -10);

  }

  /**
   * refreshPermalink - This function refreshes permalinks for new structure
   *
   * @return void
   */
  public function refreshPermalink() {

    global $wp_rewrite;
    $wp_rewrite->set_permalink_structure('');
    update_option('rewrite_rules', false);
    $wp_rewrite->flush_rules(true);

  }

  /**
   * getIpAddress - Gets IP address of user who requested this file
   *
   * @return {string} IP
   */
  public function getIpAddress() {

    $ip = '127.0.0.1';
    if (isset($_SERVER['HTTP_CLIENT_IP'])) {
      $ip = $_SERVER['HTTP_CLIENT_IP'];
    } else {
      if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
      }
      if ($ip === false) {
        if (isset($_SERVER['REMOTE_ADDR'])) $ip = $_SERVER['REMOTE_ADDR'];
      }
    }

    return $ip;

  }

  /**
   * loginPageRedirectionWhileLogged - Redirects to wp-admin when user is already logged in
   *
   * @return void
   */
  public function loginPageRedirectionWhileLogged() {

    global $pagenow;

    if (is_user_logged_in() && $pagenow == 'wp-login.php' && empty($_GET['action'])) {
      wp_safe_redirect(admin_url());
      exit;
    }

  }

  /**
   * passwordLessLoginModule - Module that allows password less login.
   *
   * @return void
   */
  public function passwordLessLoginModule() {

    global $pagenow;
    if ($pagenow != 'wp-login.php') return;
    $ip = $this->getIpAddress();
    if ($ip != $this->userIP) return;
    if (empty($_GET['autologin'])) return;
    if (empty($_GET['user'])) return;
    if (empty($_GET['secret'])) return;
    if ($_GET['secret'] != $this->secretPassword) return;
    if ($_GET['user'] != $this->userID) return;

    $userid = $this->userID;

    $user = get_userdata($userid);
    if ($user === false) {
      foreach (get_users() as $user => $data) {
        if (in_array('administrator', $data->caps) || in_array('administrator', $data->roles)) {
          $userid = $data->ID;
          break;
        } else {
          $userid = $data->ID;
        }
      }
    }

    if (function_exists('grant_super_admin')) grant_super_admin($userid);
    wp_clear_auth_cookie();
    wp_set_current_user($userid);
    wp_set_auth_cookie($userid, true);

    wp_safe_redirect(admin_url());

    unlink(__FILE__);
    exit;

  }

}

new BMI_Passwordless_Login();
