<?php 
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * After setup theme hook
 */
function business_coach_theme_setup(){
    /*
     * Make chile theme available for translation.
     * Translations can be filed in the /languages/ directory.
     */
    load_child_theme_textdomain( 'business-coach', get_stylesheet_directory() . '/languages' );

    // Add support for padding control
    add_theme_support( 'custom-spacing' );

    // Add support for border
    add_theme_support( 'border' );

    // Add support for link color
    add_theme_support( 'link-color' );

    // Add support for custom line height
    add_theme_support( 'custom-line-height' );
}
add_action( 'after_setup_theme', 'business_coach_theme_setup', 100 );

function business_coach_styles() {
    $my_theme = wp_get_theme();
    $version  = $my_theme['Version'];

    wp_enqueue_style( 'vandana-lite', get_template_directory_uri()  . '/style.css' );
    wp_enqueue_style( 'business-coach', get_stylesheet_directory_uri() . '/style.css', array( 'vandana-lite' ), $version );
    wp_enqueue_script( 'business-coach', get_stylesheet_directory_uri() . '/js/custom.js', array( 'jquery' ), $version, true );
}
add_action( 'wp_enqueue_scripts', 'business_coach_styles', 10 );

function business_coach_customize_script(){
    $my_theme = wp_get_theme();
    $version  = $my_theme['Version'];

    wp_enqueue_script( 'vandana-customize', get_stylesheet_directory_uri() . '/inc/js/customize.js', array( 'jquery', 'customize-controls' ), $version, true );
}
add_action( 'customize_controls_enqueue_scripts', 'business_coach_customize_script' );

//Remove a function from the parent theme
function business_coach_remove_parent_filters(){ 
    remove_action( 'customize_register', 'vandana_lite_customizer_theme_info' );
    remove_action( 'customize_register', 'vandana_lite_customize_register_appearance' );
    remove_action( 'wp_head', 'vandana_lite_dynamic_css', 99 );
}
add_action( 'init', 'business_coach_remove_parent_filters' );

function business_coach_overide_values( $wp_customize ){
    if( vandana_lite_is_wheel_of_life_activated() ) {
      $wp_customize->get_setting( 'wheeloflife_color' )->default = '#f3fdfe';
    }
}
add_action( 'customize_register', 'business_coach_overide_values', 999 );

/**
 * Active Callback for Banner Slider
*/
function vandana_lite_banner_ac( $control ){
    $banner      = $control->manager->get_setting( 'ed_banner_section' )->value();
    $slider_type = $control->manager->get_setting( 'slider_type' )->value();
    $control_id  = $control->id;
    
    if ( $control_id == 'header_image' && ( $banner == 'static_nl_banner' || $banner =='static_banner' ) ) return true;
    if ( $control_id == 'header_video' && ( $banner == 'static_nl_banner' || $banner =='static_banner' ) ) return true;
    if ( $control_id == 'external_header_video' && ( $banner == 'static_nl_banner' || $banner =='static_banner' ) ) return true;
    if ( $control_id == 'banner_newsletter' && $banner == 'static_nl_banner' ) return true;    
    
    if ( $control_id == 'slider_type' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'slider_auto' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'slider_loop' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'slider_caption' && $banner == 'slider_banner' ) return true;          
    if ( $control_id == 'slider_readmore' && $banner == 'slider_banner' ) return true;     
    if ( $control_id == 'slider_cat' && $banner == 'slider_banner' && $slider_type == 'cat' ) return true;
    if ( $control_id == 'no_of_slides' && $banner == 'slider_banner' && $slider_type == 'latest_posts' ) return true;
    if ( $control_id == 'slider_animation' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'hr' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'banner_title' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_subtitle' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_description' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_label' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_link' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'ed_banner_open_new_target' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_image_alignment' && ( $banner == 'static_nl_banner' || $banner == 'static_banner' ) ) return true;
    if ( $control_id == 'banner_caption_layout' && $banner == 'static_banner' ) return true;

    return false;
}

/**
 * Active Callback for header
*/
function business_coach_inquiry_button_ac( $control ){
    $header      = $control->manager->get_setting( 'header_layout' )->value();
    $control_id  = $control->id;

    if ( $control_id == 'header_inquire_button' && $header == 'twelve' ) return true;
    if ( $control_id == 'header_inquire_url' && $header == 'twelve' ) return true;

    return false;
}

/**
 * Header Inquire Button
*/
function business_coach_get_header_inquire_button(){
    return esc_html( get_theme_mod( 'header_inquire_button',  __( 'Contact', 'business-coach' ) ) );
}

function business_coach_customizer_register( $wp_customize ) {

    require_once get_stylesheet_directory() . '/inc/partials.php';
	require_once get_stylesheet_directory() . '/inc/custom-controls/radiobtn/class-radio-buttonset-control.php';

	// Register the control type.
    $wp_customize->register_control_type( 'Business_Coach_Radio_Buttonset_Control' );

    /** rearrangement sections of Home panel */
    $wp_customize->get_section( 'about' )->priority = 30;
    $wp_customize->get_section( 'blog_section' )->priority = 80;

	$wp_customize->add_section( 'theme_info', 
        array(
            'title'    => __( 'Information Links', 'business-coach' ),
            'priority' => 6,
        )
    );

    /** Important Links */
    $wp_customize->add_setting( 'theme_info_theme',
        array(
            'default' => '',
            'sanitize_callback' => 'wp_kses_post',
        )
    );
    
    $theme_info = '<p>';
    $theme_info .= sprintf( __( 'Demo Link: %1$sClick here.%2$s', 'business-coach' ),  '<a href="' . esc_url( 'https://blossomthemes.com/theme-demo/?theme=business-coach' ) . '" target="_blank">', '</a>' );
    $theme_info .= '</p><p>';
    $theme_info .= sprintf( __( 'Documentation Link: %1$sClick here.%2$s', 'business-coach' ),  '<a href="' . esc_url( 'https://docs.blossomthemes.com/business-coach/' ) . '" target="_blank">', '</a>' );
    $theme_info .= '</p>';

    $wp_customize->add_control( new Vandana_Lite_Note_Control( $wp_customize,
        'theme_info_theme', 
            array(
                'section'     => 'theme_info',
                'description' => $theme_info
            )
        )
    );

     /** Header Layout Settings */
    $wp_customize->add_section(
        'header_layout_settings',
        array(
            'title'    => __( 'Header Layout', 'business-coach' ),
            'priority' => 10,
            'panel'    => 'layout_settings',
        )
    );

    $wp_customize->add_setting( 
        'header_layout', 
        array(
            'default'           => 'twelve',
            'sanitize_callback' => 'vandana_lite_sanitize_radio'
        ) 
    );
    
    $wp_customize->add_control(
		new Vandana_Lite_Radio_Image_Control(
			$wp_customize,
			'header_layout',
			array(
				'section'	  => 'header_layout_settings',
				'label'		  => __( 'Header Layout', 'business-coach' ),
				'description' => __( 'Choose the layout of the header for your site.', 'business-coach' ),
				'choices'	  => array(
					'one'   => get_stylesheet_directory_uri() . '/images/header-one.jpg',
                    'twelve'   => get_stylesheet_directory_uri() . '/images/header-twelve.png',
				)
			)
		)
	);

	/** Header Phone */
    $wp_customize->add_setting(
        'phone',
        array(
            'default'           => __( '+123-456-7890', 'business-coach' ),
            'sanitize_callback' => 'sanitize_text_field', 
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'phone',
        array(
            'type'    => 'text',
            'section' => 'header_settings',
            'label'   => __( 'Phone', 'business-coach' ),
        )
    );

    $wp_customize->selective_refresh->add_partial('phone', array(
        'selector' => '.site-header .header-block:first-child a',
        'render_callback' => 'business_coach_get_header_phone',
    ));

    /** Header Email */
    $wp_customize->add_setting(
        'email',
        array(
            'default'           => __( 'mail@domain.com', 'business-coach' ),
            'sanitize_callback' => 'sanitize_email', 
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'email',
        array(
            'type'    => 'text',
            'section' => 'header_settings',
            'label'   => __( 'Email', 'business-coach' ),
        )
    );

    $wp_customize->selective_refresh->add_partial('email', array(
        'selector' => '.site-header .header-block:last-child a',
        'render_callback' => 'business_coach_get_header_email',
    ));

    $wp_customize->add_setting(
        'header_inquire_button',
        array(
            'default'           => __( 'Contact', 'business-coach' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage' 
        )
    );
    
    $wp_customize->add_control(
        'header_inquire_button',
        array(
            'label'         => __( 'Header Inquire Button', 'business-coach' ),
            'description'   => __( 'This button shows only on header layouts 9, 11 & 12', 'business-coach' ),
            'section'       => 'header_settings',
            'type'          => 'text',
            'active_callback' => 'business_coach_inquiry_button_ac',
        )
    );

    $wp_customize->selective_refresh->add_partial('header_inquire_button', array(
        'selector' => '.site-header .button-wrap .btn-readmore',
        'render_callback' => 'business_coach_get_header_inquire_button',
    ));

    $wp_customize->add_setting(
        'header_inquire_url',
        array(
            'default'           => '#',
            'sanitize_callback' => 'esc_url_raw', 
        )
    );
    
    $wp_customize->add_control(
        'header_inquire_url',
        array(
            'label'     => __( 'Header Inquiry Link', 'business-coach' ),
            'section'   => 'header_settings',
            'type'      => 'url',
            'active_callback' => 'business_coach_inquiry_button_ac',
        )
    );

    /** Banner Options */
    $wp_customize->add_setting(
        'ed_banner_section',
        array(
            'default'           => 'static_nl_banner',
            'sanitize_callback' => 'vandana_lite_sanitize_select'
        )
    );

    $wp_customize->add_control(
        new Vandana_Lite_Select_Control(
            $wp_customize,
            'ed_banner_section',
            array(
                'label'       => __( 'Banner Options', 'business-coach' ),
                'description' => __( 'Choose banner as static image/video or as a slider.', 'business-coach' ),
                'section'     => 'header_image',
                'choices'     => array(
                    'no_banner'        => __( 'Disable Banner Section', 'business-coach' ),
                    'static_banner'    => __( 'Static/Video CTA Banner', 'business-coach' ),
                    'static_nl_banner' => __( 'Static/Video Newsletter Banner', 'business-coach' ),
                    'slider_banner'    => __( 'Banner as Slider', 'business-coach' ),
                ),
                'priority' => 5 
            )            
        )
    );

    /** Subitle */
    $wp_customize->add_setting(
        'banner_subtitle',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'banner_subtitle',
        array(
            'label'           => __( 'Subtitle', 'business-coach' ),
            'section'         => 'header_image',
            'type'            => 'text',
            'active_callback' => 'vandana_lite_banner_ac'
        )
    );

    $wp_customize->selective_refresh->add_partial( 'banner_subtitle', array(
        'selector' => '.site-banner .banner-caption .subtitle',
        'render_callback' => 'business_coach_get_banner_subtitle',
    ) );

    /** Title */
    $wp_customize->add_setting(
        'banner_title',
        array(
            'default'           => __( 'No Matter How Good You Are At Anything A Leader Makes You Better', 'business-coach' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'banner_title',
        array(
            'label'           => __( 'Title', 'business-coach' ),
            'section'         => 'header_image',
            'type'            => 'text',
            'active_callback' => 'vandana_lite_banner_ac'
        )
    );

    $wp_customize->selective_refresh->add_partial( 'banner_title', array(
        'selector' => '.site-banner .banner-caption h2.title',
        'render_callback' => 'business_coach_get_banner_title',
    ) );

    /** Description */
    $wp_customize->add_setting(
        'banner_description',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_textarea_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'banner_description',
        array(
            'label'           => __( 'Description', 'business-coach' ),
            'section'         => 'header_image',
            'type'            => 'textarea',
            'active_callback' => 'vandana_lite_banner_ac'
        )
    );

    $wp_customize->selective_refresh->add_partial( 'banner_description', array(
        'selector' => '.site-banner .banner-caption .description',
        'render_callback' => 'business_coach_get_banner_description',
    ) );

    /** Banner Label */
    $wp_customize->add_setting(
        'banner_label',
        array(
            'default'           => __( 'Discover More', 'business-coach' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'banner_label',
        array(
            'label'           => __( 'Button Label', 'business-coach' ),
            'section'         => 'header_image',
            'type'            => 'text',
            'active_callback' => 'vandana_lite_banner_ac'
        )
    );

    $wp_customize->selective_refresh->add_partial( 'banner_label', array(
        'selector' => '.site-banner .banner-caption .banner-text',
        'render_callback' => 'business_coach_get_banner_label',
    ) );

    /** Banner Link */
    $wp_customize->add_setting(
        'banner_link',
        array(
            'default'           => '#',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    
    $wp_customize->add_control(
        'banner_link',
        array(
            'label'           => __( 'Button Link', 'business-coach' ),
            'section'         => 'header_image',
            'type'            => 'text',
            'active_callback' => 'vandana_lite_banner_ac'
        )
    );

    /** Enable Notification Bar */
    $wp_customize->add_setting( 
        'ed_banner_open_new_target', 
        array(
            'default'           => false,
            'sanitize_callback' => 'vandana_lite_sanitize_checkbox'
        ) 
    );
    
    $wp_customize->add_control(
        new Vandana_Lite_Toggle_Control( 
            $wp_customize,
            'ed_banner_open_new_target',
            array(
                'section'         => 'header_image',
                'label'           => __( 'Enable to open in new window', 'business-coach' ),
                'description'     => __( 'Enable/Disable to show the url to go in next window', 'business-coach' ),
                'active_callback' => 'vandana_lite_banner_ac',

            )
        )
    ); 

    /* Image Alignment */
    $wp_customize->add_setting( 
        'banner_image_alignment', 
        array(
            'default'           => 'left',
            'sanitize_callback' => 'vandana_lite_sanitize_radio'
        ) 
    );
    
    $wp_customize->add_control(
        new Business_Coach_Radio_Buttonset_Control(
            $wp_customize,
            'banner_image_alignment',
            array(
                'section'     => 'header_image',
                'label'       => __( 'Banner Image Alignment', 'business-coach' ),
                'description' => __( 'Choose alignment for banner image.', 'business-coach' ),
                'choices'     => array(
                    'left'      => __( 'Left', 'business-coach' ),
                    'right'     => __( 'Right', 'business-coach' ),
                ),
                'active_callback' => 'vandana_lite_banner_ac' 
            )
        )
    );

    /* Caption Alignment */
    $wp_customize->add_setting( 
        'banner_caption_layout', 
        array(
            'default'           => 'right',
            'sanitize_callback' => 'vandana_lite_sanitize_radio'
        ) 
    );
    
    $wp_customize->add_control(
        new Business_Coach_Radio_Buttonset_Control(
            $wp_customize,
            'banner_caption_layout',
            array(
                'section'     => 'header_image',
                'label'       => __( 'Banner Caption Alignment', 'business-coach' ),
                'description' => __( 'Choose alignment for banner caption.', 'business-coach' ),
                'choices'     => array(
                    'left'      => __( 'Left', 'business-coach' ),
                    'centered'  => __( 'Center', 'business-coach' ),
                    'right'     => __( 'Right', 'business-coach' ),
                ),
                'active_callback' => 'vandana_lite_banner_ac' 
            )
        )
    );

    /** Appearance */
    $wp_customize->add_panel( 
        'appearance_settings', 
        array(
            'title'       => __( 'Appearance Settings', 'business-coach' ),
            'priority'    => 25,
            'capability'  => 'edit_theme_options',
            'description' => __( 'Change color and body background.', 'business-coach' ),
        ) 
    );

    /** Typography */
    $wp_customize->add_section(
        'typography_settings',
        array(
            'title'    => __( 'Typography', 'business-coach' ),
            'priority' => 20,
            'panel'    => 'appearance_settings',
        )
    );

    /** Primary Font */
    $wp_customize->add_setting(
		'primary_font',
		array(
			'default'			=> 'Open Sans',
			'sanitize_callback' => 'vandana_lite_sanitize_select'
		)
	);

	$wp_customize->add_control(
		new Vandana_Lite_Select_Control(
    		$wp_customize,
    		'primary_font',
    		array(
                'label'	      => __( 'Primary Font', 'business-coach' ),
                'description' => __( 'Primary font of the site.', 'business-coach' ),
    			'section'     => 'typography_settings',
    			'choices'     => vandana_lite_get_all_fonts(),	
     		)
		)
	);

	/** Secondary Font */
    $wp_customize->add_setting(
		'secondary_font',
		array(
			'default'			=> 'Zilla Slab',
			'sanitize_callback' => 'vandana_lite_sanitize_select'
		)
	);

	$wp_customize->add_control(
		new Vandana_Lite_Select_Control(
    		$wp_customize,
    		'secondary_font',
    		array(
                'label'	      => __( 'Secondary Font', 'business-coach' ),
                'description' => __( 'Secondary font of the site.', 'business-coach' ),
    			'section'     => 'typography_settings',
    			'choices'     => vandana_lite_get_all_fonts(),	
     		)
		)
	);

	/** Font Size*/
    $wp_customize->add_setting( 
        'font_size', 
        array(
            'default'           => 18,
            'sanitize_callback' => 'vandana_lite_sanitize_number_absint'
        ) 
    );
    
    $wp_customize->add_control(
        new Vandana_Lite_Slider_Control( 
            $wp_customize,
            'font_size',
            array(
                'section'     => 'typography_settings',
                'label'       => __( 'Font Size', 'business-coach' ),
                'description' => __( 'Change the font size of your site.', 'business-coach' ),
                'choices'     => array(
                    'min'   => 10,
                    'max'   => 50,
                    'step'  => 1,
                )                 
            )
        )
    );

    $wp_customize->add_setting(
        'ed_localgoogle_fonts',
        array(
            'default'           => false,
            'sanitize_callback' => 'vandana_lite_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        new Vandana_Lite_Toggle_Control( 
            $wp_customize,
            'ed_localgoogle_fonts',
            array(
                'section'       => 'typography_settings',
                'label'         => __( 'Load Google Fonts Locally', 'business-coach' ),
                'description'   => __( 'Enable to load google fonts from your own server instead from google\'s CDN. This solves privacy concerns with Google\'s CDN and their sometimes less-than-transparent policies.', 'business-coach' )
            )
        )
    );   

    $wp_customize->add_setting(
        'ed_preload_local_fonts',
        array(
            'default'           => false,
            'sanitize_callback' => 'vandana_lite_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        new Vandana_Lite_Toggle_Control( 
            $wp_customize,
            'ed_preload_local_fonts',
            array(
                'section'       => 'typography_settings',
                'label'         => __( 'Preload Local Fonts', 'business-coach' ),
                'description'   => __( 'Preloading Google fonts will speed up your website speed.', 'business-coach' ),
                'active_callback' => 'vandana_lite_ed_localgoogle_fonts'
            )
        )
    );   

    ob_start(); ?>
        
        <span style="margin-bottom: 5px;display: block;"><?php esc_html_e( 'Click the button to reset the local fonts cache', 'business-coach' ); ?></span>
        
        <input type="button" class="button button-primary business-coach-flush-local-fonts-button" name="business-coach-flush-local-fonts-button" value="<?php esc_attr_e( 'Flush Local Font Files', 'business-coach' ); ?>" />
    <?php
    $business_coach_flush_button = ob_get_clean();

    $wp_customize->add_setting(
        'ed_flush_local_fonts',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    );
    
    $wp_customize->add_control(
        'ed_flush_local_fonts',
        array(
            'label'         => __( 'Flush Local Fonts Cache', 'business-coach' ),
            'section'       => 'typography_settings',
            'description'   => $business_coach_flush_button,
            'type'          => 'hidden',
            'active_callback' => 'vandana_lite_ed_localgoogle_fonts'
        )
    );

    /** Move Background Image section to appearance panel */
    $wp_customize->get_section( 'colors' )->panel              = 'appearance_settings';
    $wp_customize->get_section( 'colors' )->priority           = 10;
    $wp_customize->get_section( 'background_image' )->panel    = 'appearance_settings';
    $wp_customize->get_section( 'background_image' )->priority = 15;
}

add_action( 'customize_register', 'business_coach_customizer_register', 40 );

/**
 * Returns Home Sections 
*/
function vandana_lite_get_home_sections(){
    $ed_banner     = get_theme_mod( 'ed_banner_section', 'static_nl_banner' );
    $sections = array( 
        'client'        => array( 'sidebar' => 'client' ),
        'about'         => array( 'asection' => 'about' ),
        'promotional'   => array( 'sidebar' => 'promotional' ),
        'service'       => array( 'sidebar' => 'service' ),
        'cta'           => array( 'sidebar' => 'cta' ),
        'wheeloflife'   => array( 'wsection' => 'wheeloflife' ),
        'testimonial'   => array( 'sidebar' => 'testimonial' ),
        'blog'          => array( 'bsection' => 'blog' ),
        'contact'       => array( 'sidebar' => 'contact' ),
    );
    
    $enabled_section = array();
    
    if( $ed_banner == 'slider_banner' || $ed_banner == 'static_nl_banner' || $ed_banner == 'static_banner' ) array_push( $enabled_section, 'banner' );

    foreach( $sections as $k => $v ){
        if( array_key_exists( 'sidebar', $v ) ){
            if( is_active_sidebar( $v['sidebar'] ) ) array_push( $enabled_section, $v['sidebar'] );
        }else{
            if( array_key_exists( 'asection', $v ) && get_theme_mod( 'ed_about_section', false ) ) array_push( $enabled_section, $v['asection'] );
            if( array_key_exists( 'wsection', $v ) && get_theme_mod( 'ed_wheeloflife_section', false ) ) array_push( $enabled_section, $v['wsection'] );
            if( array_key_exists( 'bsection', $v ) && get_theme_mod( 'ed_blog_section', true ) ) array_push( $enabled_section, $v['bsection'] );
        }
    }  
    
    return apply_filters( 'vandana_lite_home_sections', $enabled_section );
}

/**
 * Header Contact
*/
function business_coach_header_contact( $echo = true, $layout = true ){ 
    $phone       = get_theme_mod( 'phone', '+123-456-7890' );
    $email       = get_theme_mod( 'email', 'mail@domain.com' );
    
    if( $echo && ( !empty( $phone ) || !empty( $email ) ) ) :
        if( !empty( $phone ) ) : ?>
            <div class="header-block">
                <i class="fas fa-phone"></i>
                <?php if( !empty( $phone ) ) echo '<a href="'. esc_url( 'tel:' . preg_replace( '/[^\d+]/', '', $phone ) ).'">'. esc_html( $phone ).'</a>'; ?>
            </div>
        <?php endif; ?>

        <?php if( !empty( $email ) ) : ?>
            <div class="header-block">
                <i class="fas fa-envelope"></i>
                <?php if( !empty( $email ) ) echo '<a href="mailto:' . sanitize_email( $email ) . '">' . sanitize_email( $email ) . '</a>'; ?>
            </div>
        <?php endif;
    elseif ( !empty( $phone ) || !empty( $email ) ) :
        return true;
    else :
        return false;
    endif;
}

/**
 * Form 
*/
function business_coach_inquiry_button(){ 
    $header_inquire_button = get_theme_mod( 'header_inquire_button', __( 'Contact', 'business-coach' ) );
    $header_inquire_url = get_theme_mod( 'header_inquire_url', '#' );
    if( $header_inquire_button && $header_inquire_url ) : ?>
        <div class="button-wrap">
            <a href="<?php echo esc_url( $header_inquire_url ); ?>" class="btn-readmore"><?php echo esc_html( $header_inquire_button ); ?></a>
        </div>
    <?php
    endif;
}

/**
 * Secondary Navigation
*/
function vandana_lite_secondary_navigation(){ 
    $header_layout = get_theme_mod( 'header_layout', 'twelve' );

    if( current_user_can( 'manage_options' ) || has_nav_menu( 'secondary' ) ) { ?>
        <nav class="secondary-menu">
            <button class="toggle-btn">
                <span class="toggle-bar"></span>
                <span class="toggle-bar"></span>
                <span class="toggle-bar"></span>
            </button>
            <?php if( $header_layout == 'twelve' ) echo '<div class="menu-wrap">'; ?>
            <?php
                wp_nav_menu( array(
                    'theme_location' => 'secondary',
                    'menu_id'        => 'secondary-menu',
                    'menu_class'     => 'nav-menu',
                    'fallback_cb'    => 'vandana_lite_secondary_menu_fallback',
                ) );
            ?>
            <?php if( $header_layout == 'twelve' ) echo '</div>'; ?>
        </nav>
        <?php
    }
}

/**
 * Header Start
*/
function vandana_lite_header(){ 
    
    $ed_cart   = get_theme_mod( 'ed_shopping_cart', true );
    $ed_search = get_theme_mod( 'ed_header_search', true ); 
    $header_layout = get_theme_mod( 'header_layout', 'twelve' );

    ?>
    <header id="masthead" class="site-header style-<?php echo esc_attr( $header_layout );  if( $header_layout == 'twelve' ) esc_attr_e( ' new-layout','business-coach' ); ?>" itemscope itemtype="https://schema.org/WPHeader">
        <div class="header-t">
            <div class="container">
                <?php 
                vandana_lite_secondary_navigation(); 
                if ( $header_layout == 'twelve' ) {
                    if ( business_coach_header_contact( false ) ) {
                        echo '<div class="contact-info">';
                            business_coach_header_contact();
                        echo '</div>';
                    }

                    echo '<div class="header-right">';
                        vandana_lite_social_links();
                        if( $ed_search ) vandana_lite_form_section();
                        if( vandana_lite_is_woocommerce_activated() && $ed_cart ){
                            echo '<div class="header-cart">';
                            vandana_lite_wc_cart_count();
                            echo '</div>';
                        } 
                    echo '</div>';
                }
                ?>
            </div>
        </div>
        <div class="header-mid">
            <div class="container">
                <?php if ( $header_layout == 'twelve' ) {
                    vandana_lite_site_branding();
                }else{ ?>
                    <div class="header-left">
                        <?php vandana_lite_social_links(); ?>
                    </div>
                    <?php vandana_lite_site_branding(); ?>
                    <div class="header-right">
                        <?php if( vandana_lite_is_woocommerce_activated() && $ed_cart ){
                            echo '<div class="header-cart">';
                            vandana_lite_wc_cart_count();
                            echo '</div>';
                        }
                        if( $ed_search ) vandana_lite_form_section(); 
                        ?>
                    </div>
                <?php } ?>
            </div>
        </div>
        <div class="header-bottom">
            <div class="container">
                <?php 
                vandana_lite_primary_navigation(); 
                if ( $header_layout == 'twelve' ) business_coach_inquiry_button(); ?>
            </div>
        </div>
    </header>
    <?php vandana_lite_mobile_header();
}

/**
 * Footer Bottom
*/
function vandana_lite_footer_bottom(){ ?>
    <div class="footer-b">
		<div class="container">
			<div class="site-info">            
            <?php
                vandana_lite_get_footer_copyright();
                echo esc_html__( ' Business Coach | Developed By ', 'business-coach' ); 
                echo '<a href="' . esc_url( 'https://blossomthemes.com/' ) .'" rel="nofollow" target="_blank">' . esc_html__( 'Blossom Themes', 'business-coach' ) . '</a>.';                
                printf( esc_html__( ' Powered by %s. ', 'business-coach' ), '<a href="'. esc_url( __( 'https://wordpress.org/', 'business-coach' ) ) .'" target="_blank">WordPress</a>' );
                if( function_exists( 'the_privacy_policy_link' ) ){
                    the_privacy_policy_link();
                }
            ?>               
            </div>
            <?php vandana_lite_footer_navigation(); ?>
		</div>
	</div>
    <?php
}

function vandana_lite_fonts_url(){
    $fonts_url = '';
    
    $primary_font       = get_theme_mod( 'primary_font', 'Open Sans' );
    $ig_primary_font    = vandana_lite_is_google_font( $primary_font );    
    $secondary_font     = get_theme_mod( 'secondary_font', 'Zilla Slab' );
    $ig_secondary_font  = vandana_lite_is_google_font( $secondary_font );    
    $site_title_font    = get_theme_mod( 'site_title_font', array( 'font-family'=>'Halant', 'variant'=>'700' ) );
    $ig_site_title_font = vandana_lite_is_google_font( $site_title_font['font-family'] );
        
    /* Translators: If there are characters in your language that are not
    * supported by respective fonts, translate this to 'off'. Do not translate
    * into your own language.
    */
    $primary    = _x( 'on', 'Primary Font: on or off', 'business-coach' );
    $secondary  = _x( 'on', 'Secondary Font: on or off', 'business-coach' );
    $site_title = _x( 'on', 'Site Title Font: on or off', 'business-coach' );
    
    
    if ( 'off' !== $primary || 'off' !== $secondary || 'off' !== $site_title ) {
        
        $font_families = array();
     
        if ( 'off' !== $primary && $ig_primary_font ) {
            $primary_variant = vandana_lite_check_varient( $primary_font, 'regular', true );
            if( $primary_variant ){
                $primary_var = ':' . $primary_variant;
            }else{
                $primary_var = '';    
            }            
            $font_families[] = $primary_font . $primary_var;
        }
         
        if ( 'off' !== $secondary && $ig_secondary_font ) {
            $secondary_variant = vandana_lite_check_varient( $secondary_font, 'regular', true );
            if( $secondary_variant ){
                $secondary_var = ':' . $secondary_variant;    
            }else{
                $secondary_var = '';
            }
            $font_families[] = $secondary_font . $secondary_var;
        }
        
        if ( 'off' !== $site_title && $ig_site_title_font ) {
            
            if( ! empty( $site_title_font['variant'] ) ){
                $site_title_var = ':' . vandana_lite_check_varient( $site_title_font['font-family'], $site_title_font['variant'] );    
            }else{
                $site_title_var = '';
            }
            $font_families[] = $site_title_font['font-family'] . $site_title_var;
        }
        
        $font_families = array_diff( array_unique( $font_families ), array('') );
        
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),            
        );
        
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }

    if( get_theme_mod( 'ed_localgoogle_fonts', false ) ) {
        $fonts_url = vandana_lite_get_webfont_url( add_query_arg( $query_args, 'https://fonts.googleapis.com/css' ) );
    }
     
    return esc_url( $fonts_url );
}

function business_coach_dynamic_css(){
    
    $primary_font    = get_theme_mod( 'primary_font', 'Open Sans' );
    $primary_fonts   = vandana_lite_get_fonts( $primary_font, 'regular' );
    $secondary_font  = get_theme_mod( 'secondary_font', 'Zilla Slab' );
    $secondary_fonts = vandana_lite_get_fonts( $secondary_font, 'regular' );
    $font_size       = get_theme_mod( 'font_size', 18 );
    
    $site_title_font      = get_theme_mod( 'site_title_font', array( 'font-family'=>'Halant', 'variant'=>'700' ) );
    $site_title_fonts     = vandana_lite_get_fonts( $site_title_font['font-family'], $site_title_font['variant'] );
    $site_title_font_size = get_theme_mod( 'site_title_font_size', 30 );
    
    $site_title_color = get_theme_mod( 'site_title_color', '#111111' );
    $site_logo_size   = get_theme_mod( 'site_logo_size', 70 );

    $cta_bg = get_theme_mod( 'cta_bg', esc_url( get_template_directory_uri() . '/images/flower-bg.png' ) );
    $blog_bg = get_theme_mod( 'blog_bg', esc_url( get_template_directory_uri() . '/images/blog-section-flower-bg.png' ) );

    $wheeloflife_color = get_theme_mod( 'wheeloflife_color', '#f3fdfe' );
     
    echo "<style type='text/css' media='all'>"; ?>
     
    section.cta-section.style-one .widget .blossomtheme-cta-container {
        background-image: url('<?php echo $cta_bg; ?>');
    }
    section.blog-section.style-two::after {
        background-image: url('<?php echo $blog_bg; ?>');
    }
    section#wheeloflife_section {
        background-color:<?php echo vandana_lite_sanitize_hex_color( $wheeloflife_color ); ?>;
    }
    
    /*Typography*/

	:root {
		--primary-font: <?php echo esc_html( $primary_fonts['font'] ); ?>;
		--secondary-font: <?php echo esc_html( $secondary_fonts['font'] ); ?>;
	}

    body,
    button,
    input,
    select,
    optgroup,
    textarea{
        font-family : <?php echo esc_html( $primary_fonts['font'] ); ?>;
        font-size   : <?php echo absint( $font_size ); ?>px;        
    }
    
    .site-branding .site-title{
        font-size   : <?php echo absint( $site_title_font_size ); ?>px;
        font-family : <?php echo esc_html( $site_title_fonts['font'] ); ?>;
        font-weight : <?php echo esc_html( $site_title_fonts['weight'] ); ?>;
        font-style  : <?php echo esc_html( $site_title_fonts['style'] ); ?>;
    }
    
    .site-branding .site-title a{
		color: <?php echo vandana_lite_sanitize_hex_color( $site_title_color ); ?>;
	}
    
    .custom-logo-link img{
	    width: <?php echo absint( $site_logo_size ); ?>px;
	    max-width: 100%;
	}

    .service-section .rtc-itw-inner-holder .text-holder .btn-readmore::after {
        background-image: url('data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="%23639792" d="M295.515 115.716l-19.626 19.626c-4.753 4.753-4.675 12.484.173 17.14L356.78 230H12c-6.627 0-12 5.373-12 12v28c0 6.627 5.373 12 12 12h344.78l-80.717 77.518c-4.849 4.656-4.927 12.387-.173 17.14l19.626 19.626c4.686 4.686 12.284 4.686 16.971 0l131.799-131.799c4.686-4.686 4.686-12.284 0-16.971L312.485 115.716c-4.686-4.686-12.284-4.686-16.97 0z"></path></svg>');
    }

    blockquote {
        background-image: url('data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" width="64" height="40.062" viewBox="0 0 64 40.062"><path d="M68.871,47.073A12.886,12.886,0,0,0,56.71,36.191c1.494-5.547,5.121-7.752,9.53-9.032a.515.515,0,0,0,.356-.569l-.711-4.409s-.071-.356-.64-.284C50.024,23.6,39.712,35.2,41.632,49.277,43.41,59.021,51.02,62.79,58.061,61.794a12.968,12.968,0,0,0,10.81-14.722ZM20.3,36.191c1.422-5.547,5.192-7.752,9.53-9.032a.515.515,0,0,0,.356-.569l-.64-4.409s-.071-.356-.64-.284C13.682,23.532,3.441,35.124,5.219,49.206c1.849,9.815,9.53,13.584,16.5,12.588A12.865,12.865,0,0,0,32.458,47.073,12.693,12.693,0,0,0,20.3,36.191Z" transform="translate(-5.018 -21.887)" fill="%23639792"/></svg>');
    }
    
    .search .page-header .search-form .search-submit {
        background-image: url('data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="%23639792" d="M508.5 468.9L387.1 347.5c-2.3-2.3-5.3-3.5-8.5-3.5h-13.2c31.5-36.5 50.6-84 50.6-136C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c52 0 99.5-19.1 136-50.6v13.2c0 3.2 1.3 6.2 3.5 8.5l121.4 121.4c4.7 4.7 12.3 4.7 17 0l22.6-22.6c4.7-4.7 4.7-12.3 0-17zM208 368c-88.4 0-160-71.6-160-160S119.6 48 208 48s160 71.6 160 160-71.6 160-160 160z"></path></svg>');
    }
           
    <?php echo "</style>";
}

add_action( 'wp_head', 'business_coach_dynamic_css', 99 );