<?php
/**
 * Banner Section
 * 
 * @package Vandana_Lite
 */

$ed_banner                 = get_theme_mod( 'ed_banner_section', 'static_nl_banner' );
$slider_type               = get_theme_mod( 'slider_type', 'latest_posts' ); 
$slider_cat                = get_theme_mod( 'slider_cat' );
$posts_per_page            = get_theme_mod( 'no_of_slides', 3 );
$ed_caption                = get_theme_mod( 'slider_caption', true );
$read_more                 = get_theme_mod( 'slider_readmore', __( 'Read More', 'business-coach' ) );
$banner_newsletter         = get_theme_mod( 'banner_newsletter' );
$banner_subtitle           = get_theme_mod( 'banner_subtitle' );
$banner_title              = get_theme_mod( 'banner_title', __( 'No Matter How Good You Are At Anything A Leader Makes You Better', 'business-coach' ) );
$banner_description        = get_theme_mod( 'banner_description' );
$banner_label              = get_theme_mod( 'banner_label', __( 'Discover More', 'business-coach' ) );
$banner_link               = get_theme_mod( 'banner_link', '#' );
$ed_banner_open_new_target = get_theme_mod( 'ed_banner_open_new_target', '#' );
$image_alignment           = get_theme_mod( 'banner_image_alignment', 'left' );
$banner_caption            = get_theme_mod( 'banner_caption_layout', 'right' );

if( $ed_banner == 'static_banner' ){
    $style      = 'five';
}else{
    $style      = 'three';
}
        
if( ( $ed_banner == 'static_banner' || $ed_banner == 'static_nl_banner' ) && has_custom_header() ){ ?>
    <div id="banner_section" class="site-banner static-cta style-<?php echo esc_attr( $style ); ?> caption-<?php echo esc_attr( $banner_caption ); ?><?php if( has_header_video() ) echo esc_attr( ' video-banner' ); ?><?php if( $ed_banner == 'static_nl_banner' ) echo esc_attr( ' static-newsletter' ); ?> align-<?php echo esc_attr( $image_alignment ); ?>">
        <div class="item" >
            <?php 
                $header_video = get_theme_mod( 'header_video' );
                $external_header_video = get_theme_mod( 'external_header_video' );
                    the_custom_header_markup();  
                    if( $ed_banner == 'static_banner' && ( $banner_subtitle || $banner_title || $banner_description || ( $banner_label && $banner_link ) ) ){
                        ?><div class="banner-caption <?php if( ! $banner_label || ! $banner_link ) echo 'not-btn'; ?>"><?php
                        echo '<div class="container">';
                        if( $banner_subtitle ) echo '<span class="subtitle">' . esc_html( $banner_subtitle ) . '</span>';
                        if( $banner_title ) echo '<h2 class="title">' . esc_html( $banner_title ) . '</h2>';
                        if( $banner_description ) echo '<div class="description">' . wp_kses_post( wpautop( $banner_description ) ) . '</div>';
                        if( $header_video || $external_header_video ) {
                            $video_url = ( $header_video ) ? $header_video : $external_header_video;
                            echo '<div class="video-popup-btn">
                                <a href="' . esc_url( $video_url ) . '" data-fancybox="gallery">
                                    <i class="fas fa-play"></i>
                                    <span>' . __( 'Watch a Video', 'business-coach' ) . '</span>
                                </a>
                            </div>';
                        } elseif( $banner_label && $banner_link ) {
                            $target = $ed_banner_open_new_target ? ' target="_blank"' : '';
                            echo '<div class="button-wrap"><a class="btn-readmore" href="' . esc_url( $banner_link ) . '"' . $target . '><span class="banner-text">' . esc_html( $banner_label ) . '</span></a></div>';
                        }
                        echo '</div></div>';
                    }elseif( $ed_banner == 'static_nl_banner' && $banner_newsletter ){
                        echo '<div class="banner-caption"><div class="container">';
                        echo do_shortcode( wp_kses_post( $banner_newsletter ) );
                        echo '</div></div>';
                    } ?>
        </div>
    </div>
<?php
}elseif( $ed_banner == 'slider_banner' ){
    if( $slider_type == 'latest_posts' || $slider_type == 'cat' ){
        $image_size = 'vandana-lite-slider';
        $args = array(
            'post_status'         => 'publish',            
            'ignore_sticky_posts' => true
        );
        
        if( $slider_type === 'cat' && $slider_cat ){
            $args['post_type']      = 'post';
            $args['cat']            = $slider_cat; 
            $args['posts_per_page'] = -1;  
        }else{
            $args['post_type']      = 'post';
            $args['posts_per_page'] = $posts_per_page;
        }
            
        $qry = new WP_Query( $args );
        
        if( $qry->have_posts() ){ ?>
            <div id="banner_section" class="site-banner slider-one">
                <div class="item-wrapper owl-carousel">            
        			<?php while( $qry->have_posts() ){ $qry->the_post(); ?>
                    <div class="item">
                        <div class="container">
                            <?php 
                            if( has_post_thumbnail() ){
            				    echo '<div class="slider-img">';
                				the_post_thumbnail( $image_size, array( 'itemprop' => 'image' ) );    
                                echo '</div>';
                            } ?>
                            <div class="banner-caption">
                                <?php if( $ed_caption ){
                                    the_title( '<h2 class="title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                                    ?>
                                    <div class="banner-desc"><?php the_excerpt(); ?></div>
                                    <?php if( $read_more ) {
                                        echo '<div class="button-wrap">';
                                        echo '<a class="btn-readmore btn-1" href="' . esc_url( get_the_permalink() ) . '" class="btn-more">' . esc_html( $read_more ) . '</a>';
                                        echo '</div>';
                                    }
                                } ?>
                            </div>
                        </div>
        			</div>
        			<?php } ?>
                </div>                        
    		</div>                
        <?php
        }
        wp_reset_postdata();
    }
}