<?php
/**
 * Define Theme Version
 */
define( 'GRADIANTX_THEME_VERSION', '3.0' );

function gradiantx_css() {
	$parent_style = 'gradiant-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'gradiantx-style', get_stylesheet_uri(), array( $parent_style ));
	
	wp_enqueue_style('gradiantx-color-default',get_stylesheet_directory_uri() .'/assets/css/color/default.css');
	wp_dequeue_style('gradiant-default');
		
	wp_enqueue_script('gradiantx-custom-js', get_stylesheet_directory_uri() . '/assets/js/custom.js', array('jquery'), false, true);

}
add_action( 'wp_enqueue_scripts', 'gradiantx_css',999);

function gradiantx_setup()	{	
	add_theme_support( 'woocommerce' );
	add_theme_support( "title-tag" );
	add_theme_support( 'automatic-feed-links' );
}
add_action( 'after_setup_theme', 'gradiantx_setup' );

function gradiantx_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'gradiant_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => 'ffffff',
		'width'                  => 2000,
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'gradiant_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'gradiantx_custom_header_setup' );


/**
 * Dynamic Styles
 */
if( ! function_exists( 'gradiantx_dynamic_style' ) ):
    function gradiantx_dynamic_style() {

		$output_css = '';
		
			
		 /**
		 *  Breadcrumb Style
		 */
		$gradiantx_hs_breadcrumb	= get_theme_mod('hs_breadcrumb','1');	
		
		if($gradiantx_hs_breadcrumb == '') { 
				$output_css .=".gradiant-content {
					padding-top: 200px;
				}\n";
			}
		
		
		/**
		 *  Parallax
		 */
		$gradiantx_footer_parallax_enable	= get_theme_mod('footer_parallax_enable','1');	
		$gradiantx_footer_parallax_margin	= get_theme_mod('footer_parallax_margin','775');	
		
		if($gradiantx_footer_parallax_enable =='1'):
			 $output_css .="@media (min-width: 992px){.footer-parallax #content.gradiant-content { 
					 margin-bottom: ".esc_attr($gradiantx_footer_parallax_margin)."px;
			 }}\n";	
		endif; 	
		
        wp_add_inline_style( 'gradiantx-style', $output_css );
    }
endif;
add_action( 'wp_enqueue_scripts', 'gradiantx_dynamic_style',999);


/**
 * Called all the Customize file.
 */
require( get_stylesheet_directory() . '/inc/customize/gradiantx-premium.php');

/**
 * Import Options From Parent Theme
 *
 */
function gradiantx_parent_theme_options() {
	$gradiant_mods = get_option( 'theme_mods_gradiant' );
	if ( ! empty( $gradiant_mods ) ) {
		foreach ( $gradiant_mods as $gradiant_mod_k => $gradiant_mod_v ) {
			set_theme_mod( $gradiant_mod_k, $gradiant_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'gradiantx_parent_theme_options' );