<?php
/**
 * Real Estate Management Theme Customizer
 *
 * @link: https://developer.wordpress.org/themes/customize-api/customizer-objects/
 *
 * @package Real Estate Management
 */

if ( ! defined( 'REAL_ESTATE_MANAGEMENT_URL' ) ) {
    define( 'REAL_ESTATE_MANAGEMENT_URL', esc_url( 'https://www.themagnifico.net/products/property-management-wordpress-theme', 'real-estate-management') );
}
if ( ! defined( 'REAL_ESTATE_MANAGEMENT_TEXT' ) ) {
    define( 'REAL_ESTATE_MANAGEMENT_TEXT', __( 'Real Estate Pro','real-estate-management' ));
}

if ( ! defined( 'REAL_ESTATE_MANAGEMENT_BUY_TEXT' ) ) {
    define( 'REAL_ESTATE_MANAGEMENT_BUY_TEXT', __( 'Buy Real Estate Pro','real-estate-management' ));
}

use WPTRT\Customize\Section\Real_Estate_Management_Button;

add_action( 'customize_register', function( $manager ) {

    $manager->register_section_type( Real_Estate_Management_Button::class );

    $manager->add_section(
        new Real_Estate_Management_Button( $manager, 'real_estate_management_pro', [
            'title'       => esc_html( REAL_ESTATE_MANAGEMENT_TEXT, 'real-estate-management' ),
            'priority'    => 0,
            'button_text' => __( 'GET PREMIUM', 'real-estate-management' ),
            'button_url'  => esc_url( REAL_ESTATE_MANAGEMENT_URL)
        ] )
    );

} );

// Load the JS and CSS.
add_action( 'customize_controls_enqueue_scripts', function() {

    $version = wp_get_theme()->get( 'Version' );

    wp_enqueue_script(
        'real-estate-management-customize-section-button',
        get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/js/customize-controls.js' ),
        [ 'customize-controls' ],
        $version,
        true
    );

    wp_enqueue_style(
        'real-estate-management-customize-section-button',
        get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/css/customize-controls.css' ),
        [ 'customize-controls' ],
        $version
    );

} );

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function real_estate_management_customize_register($wp_customize){

     // Pro Version
    class Real_Estate_Management_Customize_Pro_Version extends WP_Customize_Control {
        public $type = 'pro_options';

        public function render_content() {
            echo '<span>For More <strong>'. esc_html( $this->label ) .'</strong>?</span>';
            echo '<a href="'. esc_url($this->description) .'" target="_blank">';
                echo '<span class="dashicons dashicons-info"></span>';
                echo '<strong> '. esc_html( REAL_ESTATE_MANAGEMENT_BUY_TEXT,'real-estate-management' ) .'<strong></a>';
            echo '</a>';
        }
    }

    // Custom Controls
    function Real_Estate_Management_sanitize_custom_control( $input ) {
        return $input;
    }

    $wp_customize->get_setting('blogname')->transport = 'postMessage';
    $wp_customize->get_setting('blogdescription')->transport = 'postMessage';

    $wp_customize->add_setting('real_estate_management_logo_title_text', array(
        'default' => true,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    
    //Logo
    $wp_customize->add_setting('real_estate_management_logo_max_height',array(
        'default'   => '',
        'sanitize_callback' => 'real_estate_management_sanitize_number_absint'
    ));
    $wp_customize->add_control('real_estate_management_logo_max_height',array(
        'label' => esc_html__('Logo Width','real-estate-management'),
        'section'   => 'title_tagline',
        'type'      => 'number'
    ));

    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_logo_title_text',array(
        'label'          => __( 'Enable Disable Title', 'real-estate-management' ),
        'section'        => 'title_tagline',
        'settings'       => 'real_estate_management_logo_title_text',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('real_estate_management_theme_description', array(
        'default' => false,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_theme_description',array(
        'label'          => __( 'Enable Disable Tagline', 'real-estate-management' ),
        'section'        => 'title_tagline',
        'settings'       => 'real_estate_management_theme_description',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('real_estate_management_logo_title_color', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'real_estate_management_logo_title_color', array(
        'label'    => __('Site Title Color', 'real-estate-management'),
        'section'  => 'title_tagline'
    )));

    $wp_customize->add_setting('real_estate_management_logo_tagline_color', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'real_estate_management_logo_tagline_color', array(
        'label'    => __('Site Tagline Color', 'real-estate-management'),
        'section'  => 'title_tagline'
    )));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_logo', array(
        'sanitize_callback' => 'Real_Estate_Management_sanitize_custom_control'
    ));
    $wp_customize->add_control( new Real_Estate_Management_Customize_Pro_Version ( $wp_customize,'pro_version_logo', array(
            'section'     => 'title_tagline',
            'type'        => 'pro_options',
            'label'       => esc_html__( 'Customizer Options', 'real-estate-management' ),
            'description' => esc_url( REAL_ESTATE_MANAGEMENT_URL ),
            'priority'    => 100
    )));

    //Header
    $wp_customize->add_section('real_estate_management_header',array(
        'title' => esc_html__('Header Option','real-estate-management')
    ));

    $wp_customize->add_setting('real_estate_management_email_text',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('real_estate_management_email_text',array(
        'label' => esc_html__('Email Text','real-estate-management'),
        'section' => 'real_estate_management_header',
        'setting' => 'real_estate_management_email_text',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('real_estate_management_email',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_email'
    ));
    $wp_customize->add_control('real_estate_management_email',array(
        'label' => esc_html__('Email','real-estate-management'),
        'section' => 'real_estate_management_header',
        'setting' => 'real_estate_management_email',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('real_estate_management_topbar_btn_text',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('real_estate_management_topbar_btn_text',array(
        'label' => esc_html__('Button Text','real-estate-management'),
        'section' => 'real_estate_management_header',
        'setting' => 'real_estate_management_topbar_btn_text',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('real_estate_management_topbar_btn_url',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('real_estate_management_topbar_btn_url',array(
        'label' => esc_html__('Button URL','real-estate-management'),
        'section' => 'real_estate_management_header',
        'setting' => 'real_estate_management_topbar_btn_url',
        'type'  => 'text'
    ));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_header_setting', array(
        'sanitize_callback' => 'Real_Estate_Management_sanitize_custom_control'
    ));
    $wp_customize->add_control( new Real_Estate_Management_Customize_Pro_Version ( $wp_customize,'pro_version_header_setting', array(
                'section'     => 'real_estate_management_header',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'real-estate-management' ),
                'description' => esc_url( REAL_ESTATE_MANAGEMENT_URL ),
                'priority'    => 100
    )));

    // General Settings
    $wp_customize->add_section('real_estate_management_general_settings',array(
        'title' => esc_html__('General Settings','real-estate-management'),
        'priority'   => 1,
    ));

    $wp_customize->add_setting('real_estate_management_site_width_layout',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control('real_estate_management_site_width_layout',array(
        'label'       => esc_html__( 'Site Width Layout','real-estate-management' ),
        'type' => 'radio',
        'section' => 'real_estate_management_general_settings',
        'choices' => array(
            'Full Width' => __('Full Width','real-estate-management'),
            'Wide Width' => __('Wide Width','real-estate-management'),
            'Container Width' => __('Container Width','real-estate-management')
        ),
    ) );

    $wp_customize->add_setting('real_estate_management_preloader_hide', array(
        'default' => 0,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_preloader_hide',array(
        'label'          => __( 'Show Theme Preloader', 'real-estate-management' ),
        'section'        => 'real_estate_management_general_settings',
        'settings'       => 'real_estate_management_preloader_hide',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('real_estate_management_preloader_type',array(
        'default' => 'Preloader 1',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control('real_estate_management_preloader_type',array(
        'type' => 'radio',
        'label' => esc_html__('Preloader Type','real-estate-management'),
        'section' => 'real_estate_management_general_settings',
        'choices' => array(
            'Preloader 1' => __('Preloader 1','real-estate-management'),
            'Preloader 2' => __('Preloader 2','real-estate-management'),
        ),
    ) );

    $wp_customize->add_setting( 'real_estate_management_preloader_bg_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_estate_management_preloader_bg_color', array(
        'label' => esc_html__('Preloader Background Color','real-estate-management'),
        'section' => 'real_estate_management_general_settings',
        'settings' => 'real_estate_management_preloader_bg_color'
    )));

    $wp_customize->add_setting( 'real_estate_management_preloader_dot_1_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_estate_management_preloader_dot_1_color', array(
        'label' => esc_html__('Preloader First Dot Color','real-estate-management'),
        'section' => 'real_estate_management_general_settings',
        'settings' => 'real_estate_management_preloader_dot_1_color',
        'active_callback' => 'real_estate_management_preloader1'
    )));

    $wp_customize->add_setting( 'real_estate_management_preloader_dot_2_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_estate_management_preloader_dot_2_color', array(
        'label' => esc_html__('Preloader Second Dot Color','real-estate-management'),
        'section' => 'real_estate_management_general_settings',
        'settings' => 'real_estate_management_preloader_dot_2_color',
        'active_callback' => 'real_estate_management_preloader1'
    )));

    $wp_customize->add_setting( 'real_estate_management_preloader2_dot_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_estate_management_preloader2_dot_color', array(
        'label' => esc_html__('Preloader Dot Color','real-estate-management'),
        'section' => 'real_estate_management_general_settings',
        'settings' => 'real_estate_management_preloader2_dot_color',
        'active_callback' => 'real_estate_management_preloader2'
    )));

    $wp_customize->add_setting('real_estate_management_sticky_header', array(
        'default' => false,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_sticky_header',array(
        'label'          => __( 'Show Sticky Header', 'real-estate-management' ),
        'section'        => 'real_estate_management_general_settings',
        'settings'       => 'real_estate_management_sticky_header',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('real_estate_management_scroll_hide', array(
        'default' => '',
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_scroll_hide',array(
        'label'          => __( 'Show Theme Scroll To Top', 'real-estate-management' ),
        'section'        => 'real_estate_management_general_settings',
        'settings'       => 'real_estate_management_scroll_hide',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('real_estate_management_scroll_top_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control('real_estate_management_scroll_top_position',array(
        'label'       => esc_html__( 'Scroll To Top Positions','real-estate-management' ),
        'type' => 'radio',
        'section' => 'real_estate_management_general_settings',
        'choices' => array(
            'Right' => __('Right','real-estate-management'),
            'Left' => __('Left','real-estate-management'),
            'Center' => __('Center','real-estate-management')
        ),
    ) );

    $wp_customize->add_setting( 'real_estate_management_scroll_bg_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_estate_management_scroll_bg_color', array(
        'label' => esc_html__('Scroll Top Background Color','real-estate-management'),
        'section' => 'real_estate_management_general_settings',
        'settings' => 'real_estate_management_scroll_bg_color'
    )));

    $wp_customize->add_setting( 'real_estate_management_scroll_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_estate_management_scroll_color', array(
        'label' => esc_html__('Scroll Top Color','real-estate-management'),
        'section' => 'real_estate_management_general_settings',
        'settings' => 'real_estate_management_scroll_color'
    )));

    $wp_customize->add_setting('real_estate_management_scroll_font_size',array(
        'default'   => '16',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('real_estate_management_scroll_font_size',array(
        'label' => __('Scroll Top Font Size','real-estate-management'),
        'description' => __('Put in px','real-estate-management'),
        'section'   => 'real_estate_management_general_settings',
        'type'      => 'number'
    ));

    $wp_customize->add_setting( 'real_estate_management_scroll_to_top_border_radius', array(
        'default'              => '',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'real_estate_management_sanitize_number_range'
    ) );
    $wp_customize->add_control( 'real_estate_management_scroll_to_top_border_radius', array(
        'label'       => esc_html__( 'Scroll To Top Border Radius','real-estate-management' ),
        'section'     => 'real_estate_management_general_settings',
        'type'        => 'range',
        'input_attrs' => array(
            'step'             => 1,
            'min'              => 1,
            'max'              => 50,
        ),
    ) );

    // Product Columns
   $wp_customize->add_setting( 'real_estate_management_products_per_row' , array(
       'default'           => '3',
       'transport'         => 'refresh',
       'sanitize_callback' => 'real_estate_management_sanitize_select',
   ) );

   $wp_customize->add_control('real_estate_management_products_per_row', array(
       'label' => __( 'Product per row', 'real-estate-management' ),
       'section'  => 'real_estate_management_general_settings',
       'type'     => 'select',
       'choices'  => array(
           '2' => '2',
           '3' => '3',
           '4' => '4',
       ),
   ) );

   //Woocommerce shop page Sidebar
    $wp_customize->add_setting('real_estate_management_woocommerce_shop_page_sidebar', array(
        'default' => true,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_woocommerce_shop_page_sidebar',array(
        'label'          => __( 'Hide Shop Page Sidebar', 'real-estate-management' ),
        'section'        => 'real_estate_management_general_settings',
        'settings'       => 'real_estate_management_woocommerce_shop_page_sidebar',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('real_estate_management_shop_page_sidebar_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control('real_estate_management_shop_page_sidebar_layout',array(
        'type' => 'select',
        'label' => __('Woocommerce Shop Page Sidebar','real-estate-management'),
        'section' => 'real_estate_management_general_settings',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','real-estate-management'),
            'Right Sidebar' => __('Right Sidebar','real-estate-management'),
        ),
    ) );

   //Woocommerce Single Product page Sidebar
    $wp_customize->add_setting('real_estate_management_woocommerce_single_product_page_sidebar', array(
        'default' => true,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_woocommerce_single_product_page_sidebar',array(
        'label'          => __( 'Hide Single Product Page Sidebar', 'real-estate-management' ),
        'section'        => 'real_estate_management_general_settings',
        'settings'       => 'real_estate_management_woocommerce_single_product_page_sidebar',
        'type'           => 'checkbox',
    )));

  $wp_customize->add_setting('real_estate_management_single_product_sidebar_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control('real_estate_management_single_product_sidebar_layout',array(
        'type' => 'select',
        'label' => __('Woocommerce Single Product Page Sidebar','real-estate-management'),
        'section' => 'real_estate_management_general_settings',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','real-estate-management'),
            'Right Sidebar' => __('Right Sidebar','real-estate-management'),
        ),
    ) );

    $wp_customize->add_setting( 'real_estate_management_woo_product_image_box_shadow', array(
        'default'              => '0',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'real_estate_management_sanitize_number_range'
    ) );
    $wp_customize->add_control( 'real_estate_management_woo_product_image_box_shadow', array(
        'label'       => esc_html__( 'Product Image Box Shadow','real-estate-management' ),
        'section'     => 'real_estate_management_general_settings',
        'type'        => 'range',
        'input_attrs' => array(
            'step'             => 1,
            'min'              => 1,
            'max'              => 50,
        ),
    ) );

    $wp_customize->add_setting('real_estate_management_woocommerce_product_sale',array(
        'default' => 'Left',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control('real_estate_management_woocommerce_product_sale',array(
        'label'       => esc_html__( 'Woocommerce Product Sale Positions','real-estate-management' ),
        'type' => 'radio',
        'section' => 'real_estate_management_general_settings',
        'choices' => array(
            'Right' => __('Right','real-estate-management'),
            'Left' => __('Left','real-estate-management'),
            'Center' => __('Center','real-estate-management')
        ),
    ) );

    $wp_customize->add_setting( 'real_estate_management_woo_product_sale_border_radius', array(
        'default'              => '',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'real_estate_management_sanitize_number_range'
    ) );
    $wp_customize->add_control( 'real_estate_management_woo_product_sale_border_radius', array(
        'label'       => esc_html__( 'Woocommerce Product Sale Border Radius','real-estate-management' ),
        'section'     => 'real_estate_management_general_settings',
        'type'        => 'range',
        'input_attrs' => array(
            'step'             => 1,
            'min'              => 1,
            'max'              => 50,
        ),
    ) );

    // Related Product
    $wp_customize->add_setting('real_estate_management_woocommerce_related_product_show_hide', array(
        'default' => true,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_woocommerce_related_product_show_hide',array(
        'label'          => __( 'Show / Hide Related product', 'real-estate-management' ),
        'section'        => 'real_estate_management_general_settings',
        'settings'       => 'real_estate_management_woocommerce_related_product_show_hide',
        'type'           => 'checkbox',
    )));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_general_setting', array(
        'sanitize_callback' => 'Real_Estate_Management_sanitize_custom_control'
    ));
    $wp_customize->add_control( new Real_Estate_Management_Customize_Pro_Version ( $wp_customize,'pro_version_general_setting', array(
        'section'     => 'real_estate_management_general_settings',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Customizer Options', 'real-estate-management' ),
        'description' => esc_url( REAL_ESTATE_MANAGEMENT_URL ),
        'priority'    => 100
    )));

    //Menu Settings
    $wp_customize->add_section('real_estate_management_menu_settings',array(
        'title' => esc_html__('Menus Settings','real-estate-management'),
    ));

    $wp_customize->add_setting('real_estate_management_menu_font_size',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('real_estate_management_menu_font_size',array(
        'label' => esc_html__('Menu Font Size','real-estate-management'),
        'section' => 'real_estate_management_menu_settings',
        'type'  => 'number'
    ));

    $wp_customize->add_setting('real_estate_management_nav_menu_text_transform',array(
        'default'=> 'Capitalize',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control('real_estate_management_nav_menu_text_transform',array(
        'type' => 'radio',
        'label' => esc_html__('Menu Text Transform','real-estate-management'),
        'choices' => array(
            'Uppercase' => __('Uppercase','real-estate-management'),
            'Capitalize' => __('Capitalize','real-estate-management'),
            'Lowercase' => __('Lowercase','real-estate-management'),
        ),
        'section'=> 'real_estate_management_menu_settings',
    ));

    $wp_customize->add_setting('real_estate_management_nav_menu_font_weight',array(
        'default'=> '600',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('real_estate_management_nav_menu_font_weight',array(
        'type' => 'number',
        'label' => esc_html__('Menu Font Weight','real-estate-management'),
        'input_attrs' => array(
            'step'             => 100,
            'min'              => 100,
            'max'              => 1000,
        ),
        'section'=> 'real_estate_management_menu_settings',
    ));

    //Slider
    $wp_customize->add_section('real_estate_management_top_slider',array(
        'title' => esc_html__('Slider Option','real-estate-management')
    ));

    $wp_customize->add_setting('real_estate_management_top_slider_setting', array(
        'default' => 1,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_top_slider_setting',array(
        'label'          => __( 'Enable Disable Slider', 'real-estate-management' ),
        'section'        => 'real_estate_management_top_slider',
        'settings'       => 'real_estate_management_top_slider_setting',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('real_estate_management_slider_title_setting', array(
        'default' => 1,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_slider_title_setting',array(
        'label'          => __( 'Enable Disable Slider Title', 'real-estate-management' ),
        'section'        => 'real_estate_management_top_slider',
        'settings'       => 'real_estate_management_slider_title_setting',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('real_estate_management_slider_content_setting', array(
        'default' => 1,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_slider_content_setting',array(
        'label'          => __( 'Enable Disable Slider Content', 'real-estate-management' ),
        'section'        => 'real_estate_management_top_slider',
        'settings'       => 'real_estate_management_slider_content_setting',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('real_estate_management_slider_button_setting', array(
        'default' => 1,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_slider_button_setting',array(
        'label'          => __( 'Enable Disable Slider Button', 'real-estate-management' ),
        'section'        => 'real_estate_management_top_slider',
        'settings'       => 'real_estate_management_slider_button_setting',
        'type'           => 'checkbox',
    )));

    for ( $count = 1; $count <= 3; $count++ ) {
        $wp_customize->add_setting( 'real_estate_management_top_slider_page' . $count, array(
            'default'           => '',
            'sanitize_callback' => 'real_estate_management_sanitize_dropdown_pages'
        ) );
        $wp_customize->add_control( 'real_estate_management_top_slider_page' . $count, array(
            'label'    => __( 'Select Slide Page', 'real-estate-management' ),
            'description' => __('Slider image size (1400 x 550)','real-estate-management'),
            'section'  => 'real_estate_management_top_slider',
            'type'     => 'dropdown-pages'
        ) );
    }

    $wp_customize->add_setting('real_estate_management_slider_excerpt_length',array(
        'sanitize_callback' => 'real_estate_management_sanitize_number_range',
        'default'  => 30,
    ));
    $wp_customize->add_control('real_estate_management_slider_excerpt_length',array(
        'label'      => esc_html__('Slider Excerpt Length', 'real-estate-management'),
        'section'     => 'real_estate_management_top_slider',
        'type'        => 'range',
        'input_attrs' => array(
            'step' => 1,
            'min'  => 1,
            'max'  => 50,
        ),
    ));

    //Slider button text
    $wp_customize->add_setting('real_estate_management_slider_button_text',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('real_estate_management_slider_button_text',array(
        'label' => __('Slider Button Text','real-estate-management'),
        'section'=> 'real_estate_management_top_slider',
        'type'=> 'text'
    ));

    //Slider Image Opacity
    

    $wp_customize->add_setting('real_estate_management_slider_opacity_setting', array(
        'default' => true,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'real_estate_management_slider_opacity_setting',array(
        'label'    => __( 'Show Image Opacity', 'real-estate-management' ),
        'section'  => 'real_estate_management_top_slider',
        'type'     => 'checkbox',
    )));

    $wp_customize->add_setting( 'real_estate_management_image_opacity_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_estate_management_image_opacity_color', array(
        'label' => __('Slider Image Opacity Color', 'real-estate-management'),
        'section' => 'real_estate_management_top_slider',
        'settings' => 'real_estate_management_image_opacity_color',
    )));

    $wp_customize->add_setting('real_estate_management_slider_opacity',array(
        'default'=> '0.4',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control('real_estate_management_slider_opacity',array(
        'type' => 'select',
        'label' => esc_html__('Slider Image Opacity','real-estate-management'),
        'choices' => array(
            '0'   => '0',
            '0.1' => '0.1',
            '0.2' => '0.2',
            '0.3' => '0.3',
            '0.4' => '0.4',
            '0.5' => '0.5',
            '0.6' => '0.6',
            '0.7' => '0.7',
            '0.8' => '0.8',
            '0.9' => '0.9',
            '1'   => '1',
        ),
        'section'=> 'real_estate_management_top_slider',
    ));

    //Slider height
    $wp_customize->add_setting('real_estate_management_slider_img_height',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('real_estate_management_slider_img_height',array(
        'label' => __('Slider Height','real-estate-management'),
        'description'   => __('Add the slider height in px(eg. 500px).','real-estate-management'),
        'input_attrs' => array(
            'placeholder' => __( '500px', 'real-estate-management' ),
        ),
        'section'=> 'real_estate_management_top_slider',
        'type'=> 'text'
    ));

    $wp_customize->add_setting('real_estate_management_phone_text',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('real_estate_management_phone_text',array(
        'label' => esc_html__('Phone Text','real-estate-management'),
        'section' => 'real_estate_management_top_slider',
        'setting' => 'real_estate_management_phone_text',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('real_estate_management_phone',array(
        'default' => '',
        'sanitize_callback' => 'real_estate_management_sanitize_phone_number'
    ));
    $wp_customize->add_control('real_estate_management_phone',array(
        'label' => esc_html__('Phone Number','real-estate-management'),
        'section' => 'real_estate_management_top_slider',
        'setting' => 'real_estate_management_phone',
        'type'  => 'text'
    ));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_slider_setting', array(
        'sanitize_callback' => 'Real_Estate_Management_sanitize_custom_control'
    ));
    $wp_customize->add_control( new Real_Estate_Management_Customize_Pro_Version ( $wp_customize,'pro_version_slider_setting', array(
                'section'     => 'real_estate_management_top_slider',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'real-estate-management' ),
                'description' => esc_url( REAL_ESTATE_MANAGEMENT_URL ),
                'priority'    => 100
    )));

    //Latest Property
    $wp_customize->add_section('real_estate_management_new_project',array(
        'title' => esc_html__('Latest Properties','real-estate-management'),
        'description' => esc_html__('Here you have to select properties which will display perticular latest properties in the home page.','real-estate-management')
    ));

    $wp_customize->add_setting('real_estate_management_projects_short_title',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('real_estate_management_projects_short_title',array(
        'label' => esc_html__('Short Title','real-estate-management'),
        'section' => 'real_estate_management_new_project',
        'setting' => 'real_estate_management_projects_short_title',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('real_estate_management_projects_title',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('real_estate_management_projects_title',array(
        'label' => esc_html__('Title','real-estate-management'),
        'section' => 'real_estate_management_new_project',
        'setting' => 'real_estate_management_projects_title',
        'type'  => 'text'
    ));

    $categories = get_categories();
    $cat_post = array();
    $cat_post[]= 'select';
    $i = 0;
    foreach($categories as $category){
        if($i==0){
            $default = $category->slug;
            $i++;
        }
        $cat_post[$category->slug] = $category->name;
    }

    $wp_customize->add_setting('real_estate_management_projects_category',array(
        'default'   => 'select',
        'sanitize_callback' => 'real_estate_management_sanitize_select',
    ));
    $wp_customize->add_control('real_estate_management_projects_category',array(
        'type'    => 'select',
        'choices' => $cat_post,
        'label' => __('Select category to display latest properties','real-estate-management'),
        'section' => 'real_estate_management_new_project',
    ));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_projects_setting', array(
        'sanitize_callback' => 'Real_Estate_Management_sanitize_custom_control'
    ));
    $wp_customize->add_control( new Real_Estate_Management_Customize_Pro_Version ( $wp_customize,'pro_version_projects_setting', array(
                'section'     => 'real_estate_management_new_project',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'real-estate-management' ),
                'description' => esc_url( REAL_ESTATE_MANAGEMENT_URL ),
                'priority'    => 100
    )));

    // Footer
    $wp_customize->add_section('real_estate_management_site_footer_section', array(
        'title' => esc_html__('Footer', 'real-estate-management'),
    ));

    $wp_customize->add_setting('real_estate_management_show_hide_footer',array(
        'default' => true,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control('real_estate_management_show_hide_footer',array(
        'type' => 'checkbox',
        'label' => __('Show / Hide Footer','real-estate-management'),
        'section' => 'real_estate_management_site_footer_section',
        'priority' => 1,
    ));

    $wp_customize->add_setting('real_estate_management_footer_background_color', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'real_estate_management_footer_background_color', array(
        'label'    => __('Footer Background Color', 'real-estate-management'),
        'section'  => 'real_estate_management_site_footer_section',
    )));

    $wp_customize->add_setting('real_estate_management_footer_bg_image',array(
        'default'   => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'real_estate_management_footer_bg_image',array(
        'label' => __('Footer Background Image','real-estate-management'),
        'section' => 'real_estate_management_site_footer_section',
    )));

    $wp_customize->add_setting('real_estate_management_footer_widget_content_alignment',array(
        'default' => 'Left',
        'transport' => 'refresh',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control('real_estate_management_footer_widget_content_alignment',array(
        'type' => 'select',
        'label' => __('Footer Widget Content Alignment','real-estate-management'),
        'section' => 'real_estate_management_site_footer_section',
        'choices' => array(
            'Left' => __('Left','real-estate-management'),
            'Center' => __('Center','real-estate-management'),
            'Right' => __('Right','real-estate-management')
        ),
    ) );

    $wp_customize->add_setting('real_estate_management_show_hide_copyright',array(
        'default' => true,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control('real_estate_management_show_hide_copyright',array(
        'type' => 'checkbox',
        'label' => __('Show / Hide Copyright','real-estate-management'),
        'section' => 'real_estate_management_site_footer_section',
    ));

    $wp_customize->add_setting('real_estate_management_footer_text_setting', array(
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('real_estate_management_footer_text_setting', array(
        'label' => __('Replace the footer text', 'real-estate-management'),
        'section' => 'real_estate_management_site_footer_section',
        'type' => 'text',
    ));

    $wp_customize->add_setting('real_estate_management_copyright_content_alignment',array(
        'default' => 'Center',
        'transport' => 'refresh',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control('real_estate_management_copyright_content_alignment',array(
        'type' => 'select',
        'label' => __('Copyright Content Alignment','real-estate-management'),
        'section' => 'real_estate_management_site_footer_section',
        'choices' => array(
            'Left' => __('Left','real-estate-management'),
            'Center' => __('Center','real-estate-management'),
            'Right' => __('Right','real-estate-management')
        ),
    ) );

    $wp_customize->add_setting('real_estate_management_copyright_background_color', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'real_estate_management_copyright_background_color', array(
        'label'    => __('Copyright Background Color', 'real-estate-management'),
        'section'  => 'real_estate_management_site_footer_section',
    )));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_footer_setting', array(
        'sanitize_callback' => 'Real_Estate_Management_sanitize_custom_control'
    ));
    $wp_customize->add_control( new Real_Estate_Management_Customize_Pro_Version ( $wp_customize,'pro_version_footer_setting', array(
        'section'     => 'real_estate_management_site_footer_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Customizer Options', 'real-estate-management' ),
        'description' => esc_url( REAL_ESTATE_MANAGEMENT_URL ),
        'priority'    => 100
    )));

    // Post Settings
     $wp_customize->add_section('real_estate_management_post_settings',array(
        'title' => esc_html__('Post Settings','real-estate-management'),
        'priority'   =>40,
    ));

    $wp_customize->add_setting('real_estate_management_post_page_title',array(
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('real_estate_management_post_page_title',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Title', 'real-estate-management'),
        'section'     => 'real_estate_management_post_settings',
        'description' => esc_html__('Check this box to enable title on post page.', 'real-estate-management'),
    ));

    $wp_customize->add_setting('real_estate_management_post_page_meta',array(
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('real_estate_management_post_page_meta',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Meta', 'real-estate-management'),
        'section'     => 'real_estate_management_post_settings',
        'description' => esc_html__('Check this box to enable meta on post page.', 'real-estate-management'),
    ));

    $wp_customize->add_setting('real_estate_management_post_page_thumb',array(
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('real_estate_management_post_page_thumb',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Thumbnail', 'real-estate-management'),
        'section'     => 'real_estate_management_post_settings',
        'description' => esc_html__('Check this box to enable thumbnail on post page.', 'real-estate-management'),
    ));

    $wp_customize->add_setting( 'real_estate_management_post_page_image_border_radius', array(
        'default'              => '0',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'real_estate_management_sanitize_number_range'
    ) );
    $wp_customize->add_control( 'real_estate_management_post_page_image_border_radius', array(
        'label'       => esc_html__( 'Post Page Image Border Radius','real-estate-management' ),
        'section'     => 'real_estate_management_post_settings',
        'type'        => 'range',
        'input_attrs' => array(
            'step'             => 1,
            'min'              => 1,
            'max'              => 50,
        ),
    ) );

    $wp_customize->add_setting( 'real_estate_management_post_page_image_box_shadow', array(
        'default'              => '0',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'real_estate_management_sanitize_number_range'
    ) );
    $wp_customize->add_control( 'real_estate_management_post_page_image_box_shadow', array(
        'label'       => esc_html__( 'Post Page Image Box Shadow','real-estate-management' ),
        'section'     => 'real_estate_management_post_settings',
        'type'        => 'range',
        'input_attrs' => array(
            'step'             => 1,
            'min'              => 1,
            'max'              => 50,
        ),
    ) );

    $wp_customize->add_setting('real_estate_management_post_page_content',array(
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('real_estate_management_post_page_content',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Content', 'real-estate-management'),
        'section'     => 'real_estate_management_post_settings',
        'description' => esc_html__('Check this box to enable content on post page.', 'real-estate-management'),
    ));

    $wp_customize->add_setting('real_estate_management_post_page_excerpt_length',array(
        'sanitize_callback' => 'real_estate_management_sanitize_number_range',
        'default'           => 30,
    ));
    $wp_customize->add_control('real_estate_management_post_page_excerpt_length',array(
        'label'       => esc_html__('Post Page Excerpt Length', 'real-estate-management'),
        'section'     => 'real_estate_management_post_settings',
        'type'        => 'range',
        'input_attrs' => array(
            'step'             => 1,
            'min'              => 1,
            'max'              => 50,
        ),
    ));

    $wp_customize->add_setting('real_estate_management_post_page_excerpt_suffix',array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => '[...]',
    ));
    $wp_customize->add_control('real_estate_management_post_page_excerpt_suffix',array(
        'type'        => 'text',
        'label'       => esc_html__('Post Page Excerpt Suffix', 'real-estate-management'),
        'section'     => 'real_estate_management_post_settings',
        'description' => esc_html__('For Ex. [...], etc', 'real-estate-management'),
    ));

    $wp_customize->add_setting('real_estate_management_post_page_btn',array(
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('real_estate_management_post_page_btn',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Button', 'real-estate-management'),
        'section'     => 'real_estate_management_post_settings',
        'description' => esc_html__('Check this box to enable button on post page.', 'real-estate-management'),
    ));

    $wp_customize->add_setting( 'real_estate_management_blog_post_columns', array(
        'default'  => 'Two',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control( 'real_estate_management_blog_post_columns', array(
        'section' => 'real_estate_management_post_settings',
        'type' => 'select',
        'label' => __( 'No. of Posts per row', 'real-estate-management' ),
        'choices' => array(
            'One'  => __( 'One', 'real-estate-management' ),
            'Two' => __( 'Two', 'real-estate-management' ),
            'Three' => __( 'Three', 'real-estate-management' ),
        )
    ));

    $wp_customize->add_setting('real_estate_management_post_page_pagination',array(
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('real_estate_management_post_page_pagination',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Pagination', 'real-estate-management'),
        'section'     => 'real_estate_management_post_settings',
        'description' => esc_html__('Check this box to enable pagination on post page.', 'real-estate-management'),
    ));

    $wp_customize->add_setting( 'real_estate_management_blog_pagination_type', array(
        'default'           => 'blog-nav-numbers',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control( 'real_estate_management_blog_pagination_type', array(
        'section' => 'real_estate_management_post_settings',
        'type' => 'select',
        'label' => __( 'Post Pagination Type', 'real-estate-management' ),
        'choices' => array(
            'blog-nav-numbers'  => __( 'Numeric', 'real-estate-management' ),
            'next-prev' => __( 'Older/Newer Posts', 'real-estate-management' ),
        )
    ));

    $wp_customize->add_setting( 'real_estate_management_blog_sidebar_position', array(
        'default'           => 'Right Side',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control( 'real_estate_management_blog_sidebar_position', array(
        'section' => 'real_estate_management_post_settings',
        'type' => 'select',
        'label' => __( 'Post Page Sidebar Position', 'real-estate-management' ),
        'choices' => array(
            'Right Side' => __( 'Right Side', 'real-estate-management' ),
            'Left Side' => __( 'Left Side', 'real-estate-management' ),
        )
    ));

    $wp_customize->add_setting('real_estate_management_single_post_thumb',array(
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('real_estate_management_single_post_thumb',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Single Post Thumbnail', 'real-estate-management'),
        'section'     => 'real_estate_management_post_settings',
        'description' => esc_html__('Check this box to enable post thumbnail on single post.', 'real-estate-management'),
    ));

    $wp_customize->add_setting('real_estate_management_single_post_meta',array(
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('real_estate_management_single_post_meta',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Single Post Meta', 'real-estate-management'),
        'section'     => 'real_estate_management_post_settings',
        'description' => esc_html__('Check this box to enable single post meta such as post date, author, category, comment etc.', 'real-estate-management'),
    ));

    $wp_customize->add_setting('real_estate_management_single_post_title',array(
            'sanitize_callback' => 'real_estate_management_sanitize_checkbox',
            'default'           => 1,
    ));
    $wp_customize->add_control('real_estate_management_single_post_title',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Single Post Title', 'real-estate-management'),
        'section'     => 'real_estate_management_post_settings',
        'description' => esc_html__('Check this box to enable title on single post.', 'real-estate-management'),
    ));

    $wp_customize->add_setting('real_estate_management_single_post_page_content',array(
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('real_estate_management_single_post_page_content',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Single Post Page Content', 'real-estate-management'),
        'section'     => 'real_estate_management_post_settings',
        'description' => esc_html__('Check this box to enable content on single post page.', 'real-estate-management'),
    ));

    $wp_customize->add_setting( 'real_estate_management_single_post_sidebar_position', array(
        'default'           => 'Right Side',
        'sanitize_callback' => 'real_estate_management_sanitize_choices'
    ));
    $wp_customize->add_control( 'real_estate_management_single_post_sidebar_position', array(
        'section' => 'real_estate_management_post_settings',
        'type' => 'select',
        'label' => __( 'Single Post Sidebar Position', 'real-estate-management' ),
        'choices' => array(
            'Right Side' => __( 'Right Side', 'real-estate-management' ),
            'Left Side' => __( 'Left Side', 'real-estate-management' ),
        )
    ));

    $wp_customize->add_setting('real_estate_management_single_post_navigation_show_hide',array(
        'default' => true,
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox'
    ));
    $wp_customize->add_control('real_estate_management_single_post_navigation_show_hide',array(
        'type' => 'checkbox',
        'label' => __('Show / Hide Post Navigation','real-estate-management'),
        'section' => 'real_estate_management_post_settings',
    ));

    $wp_customize->add_setting('real_estate_management_single_post_comment_title',array(
        'default'=> 'Leave a Reply',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('real_estate_management_single_post_comment_title',array(
        'label' => __('Add Comment Title','real-estate-management'),
        'input_attrs' => array(
        'placeholder' => __( 'Leave a Reply', 'real-estate-management' ),
        ),
        'section'=> 'real_estate_management_post_settings',
        'type'=> 'text'
    ));

    $wp_customize->add_setting('real_estate_management_single_post_comment_btn_text',array(
        'default'=> 'Post Comment',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('real_estate_management_single_post_comment_btn_text',array(
        'label' => __('Add Comment Button Text','real-estate-management'),
        'input_attrs' => array(
            'placeholder' => __( 'Post Comment', 'real-estate-management' ),
        ),
        'section'=> 'real_estate_management_post_settings',
        'type'=> 'text'
    ));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_post_setting', array(
        'sanitize_callback' => 'Real_Estate_Management_sanitize_custom_control'
    ));
    $wp_customize->add_control( new Real_Estate_Management_Customize_Pro_Version ( $wp_customize,'pro_version_post_setting', array(
            'section'     => 'real_estate_management_post_settings',
            'type'        => 'pro_options',
            'label'       => esc_html__( 'Customizer Options', 'real-estate-management' ),
            'description' => esc_url( REAL_ESTATE_MANAGEMENT_URL ),
            'priority'    => 100
    )));

    // Page Settings
    $wp_customize->add_section('real_estate_management_page_settings',array(
        'title' => esc_html__('Page Settings','real-estate-management'),
        'priority'   =>50,
    ));

    $wp_customize->add_setting('real_estate_management_single_page_title',array(
            'sanitize_callback' => 'real_estate_management_sanitize_checkbox',
            'default'           => 1,
    ));
    $wp_customize->add_control('real_estate_management_single_page_title',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Single Page Title', 'real-estate-management'),
        'section'     => 'real_estate_management_page_settings',
        'description' => esc_html__('Check this box to enable title on single page.', 'real-estate-management'),
    ));

    $wp_customize->add_setting('real_estate_management_single_page_thumb',array(
        'sanitize_callback' => 'real_estate_management_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('real_estate_management_single_page_thumb',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Single Page Thumbnail', 'real-estate-management'),
        'section'     => 'real_estate_management_page_settings',
        'description' => esc_html__('Check this box to enable page thumbnail on single page.', 'real-estate-management'),
    ));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_single_page_setting', array(
        'sanitize_callback' => 'Real_Estate_Management_sanitize_custom_control'
    ));
    $wp_customize->add_control( new Real_Estate_Management_Customize_Pro_Version ( $wp_customize,'pro_version_single_page_setting', array(
            'section'     => 'real_estate_management_page_settings',
            'type'        => 'pro_options',
            'label'       => esc_html__( 'Customizer Options', 'real-estate-management' ),
            'description' => esc_url( REAL_ESTATE_MANAGEMENT_URL ),
            'priority'    => 100
    )));
}
add_action('customize_register', 'real_estate_management_customize_register');

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function real_estate_management_customize_partial_blogname(){
    bloginfo('name');
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function real_estate_management_customize_partial_blogdescription(){
    bloginfo('description');
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function real_estate_management_customize_preview_js(){
    wp_enqueue_script('real-estate-management-customizer', esc_url(get_template_directory_uri()) . '/assets/js/customizer.js', array('customize-preview'), '20151215', true);
}
add_action('customize_preview_init', 'real_estate_management_customize_preview_js');

/*
** Load dynamic logic for the customizer controls area.
*/
function real_estate_management_panels_js() {
    wp_enqueue_style( 'real-estate-management-customizer-layout-css', get_theme_file_uri( '/assets/css/customizer-layout.css' ) );
    wp_enqueue_script( 'real-estate-management-customize-layout', get_theme_file_uri( '/assets/js/customize-layout.js' ), array(), '1.2', true );
}
add_action( 'customize_controls_enqueue_scripts', 'real_estate_management_panels_js' );


