import { Icon, Sidebar, Card, Heading } from "../../components";
import { __ } from '@wordpress/i18n';

const Homepage = () => {
    const cardLists = [
        {
            iconSvg: <Icon icon="site" />,
            heading: __('Site Identity', 'vandana-lite'),
            buttonText: __('Customize', 'vandana-lite'),
            buttonUrl: cw_dashboard.custom_logo
        },
        {
            iconSvg: <Icon icon="colorsetting" />,
            heading: __("Color Settings", 'vandana-lite'),
            buttonText: __('Customize', 'vandana-lite'),
            buttonUrl: cw_dashboard.colors
        },
        {
            iconSvg: <Icon icon="layoutsetting" />,
            heading: __("Layout Settings", 'vandana-lite'),
            buttonText: __('Customize', 'vandana-lite'),
            buttonUrl: cw_dashboard.layout
        },
        {
            iconSvg: <Icon icon="instagramsetting" />,
            heading: __("Instagram Settings", 'vandana-lite'),
            buttonText: __('Customize', 'vandana-lite'),
            buttonUrl: cw_dashboard.instagram
        },
        {
            iconSvg: <Icon icon="generalsetting" />,
            heading: __("General Settings"),
            buttonText: __('Customize', 'vandana-lite'),
            buttonUrl: cw_dashboard.general
        },
        {
            iconSvg: <Icon icon="footersetting" />,
            heading: __('Footer Settings', 'vandana-lite'),
            buttonText: __('Customize', 'vandana-lite'),
            buttonUrl: cw_dashboard.footer
        }
    ];

    const proSettings = [
        {
            heading: __('Header Layouts', 'vandana-lite'),
            para: __('Choose from different unique header layouts.', 'vandana-lite'),
            buttonText: __('Learn More', 'vandana-lite'),
            buttonUrl: cw_dashboard?.get_pro
        },
        {
            heading: __('Multiple Layouts', 'vandana-lite'),
            para: __('Choose layouts for blogs, banners, posts and more.', 'vandana-lite'),
            buttonText: __('Learn More', 'vandana-lite'),
            buttonUrl: cw_dashboard?.get_pro
        },
        {
            heading: __('Multiple Sidebar', 'vandana-lite'),
            para: __('Set different sidebars for posts and pages.', 'vandana-lite'),
            buttonText: __('Learn More', 'vandana-lite'),
            buttonUrl: cw_dashboard?.get_pro
        },
        {
            heading: __('Sticky/Floating Menu', 'vandana-lite'),
            para: __('Show a sticky/floating Menu for the site', 'vandana-lite'),
            buttonText: __('Learn More', 'vandana-lite'),
            buttonUrl: cw_dashboard?.get_pro
        },
        {
            para: __('Boost your website performance with ease.', 'vandana-lite'),
            heading: __('Performance Settings', 'vandana-lite'),
            buttonText: __('Learn More', 'vandana-lite'),
            buttonUrl: cw_dashboard?.get_pro
        },
        {
            para: __('You can create a one page scrollable website.', 'vandana-lite'),
            heading: __('One Page Website', 'vandana-lite'),
            buttonText: __('Learn More', 'vandana-lite'),
            buttonUrl: cw_dashboard?.get_pro
        },
        {
            para: __('Import the demo content to kickstart your site.', 'vandana-lite'),
            heading: __('One Click Demo Import', 'vandana-lite'),
            buttonText: __('Learn More', 'vandana-lite'),
            buttonUrl: cw_dashboard?.get_pro
        },
        {
            para: __('Easily place ads on high conversion areas.', 'vandana-lite'),
            heading: __('Advertisement Settings', 'vandana-lite'),
            buttonText: __('Learn More', 'vandana-lite'),
            buttonUrl: cw_dashboard?.get_pro
        },
    ];

    const sidebarSettings = [
        {
            heading: __('We Value Your Feedback!', 'vandana-lite'),
            icon: "star",
            para: __("Your review helps us improve and assists others in making informed choices. Share your thoughts today!", 'vandana-lite'),
            imageurl: <Icon icon="review" />,
            buttonText: __('Leave a Review', 'vandana-lite'),
            buttonUrl: cw_dashboard.review
        },
        {
            heading: __('Knowledge Base', 'vandana-lite'),
            para: __("Need help using our theme? Visit our well-organized Knowledge Base!", 'vandana-lite'),
            imageurl: <Icon icon="documentation" />,
            buttonText: __('Explore', 'vandana-lite'),
            buttonUrl: cw_dashboard.docmentation
        },
        {
            heading: __('Need Assistance? ', 'vandana-lite'),
            para: __("If you need help or have any questions, don't hesitate to contact our support team. We're here to assist you!", 'vandana-lite'),
            imageurl: <Icon icon="supportTwo" />,
            buttonText: __('Submit a Ticket', 'vandana-lite'),
            buttonUrl: cw_dashboard.support
        }
    ];

    return (
        <>
            <div className="customizer-settings">
                <div className="cw-customizer">
                    <div className="video-section">
                        <div className="cw-settings">
                            <h2>{__('Vandana Lite Tutorial', 'vandana-lite')}</h2>
                        </div>
                        <iframe src="https://www.youtube.com/embed/FsSGCV1DZG0?si=QFNWz8fx7IQRn7Lk" title={__( 'How to Start Coaching Website In 2023 | Vandana', 'vandana-lite')} frameBorder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerPolicy="strict-origin-when-cross-origin" allowFullScreen></iframe>
                    </div>
                    <Heading
                        heading={__('Quick Customizer Settings', 'vandana-lite')}
                        buttonText={__('Go To Customizer', 'vandana-lite')}
                        buttonUrl={cw_dashboard?.customizer_url}
                        openInNewTab={true}
                    />
                    <Card
                        cardList={cardLists}
                        cardPlace='customizer'
                        cardCol='three-col'
                    />
                    <Heading
                        heading={__('More features with Pro version', 'vandana-lite')}
                        buttonText={__('Go To Customizer', 'vandana-lite')}
                        buttonUrl={cw_dashboard?.customizer_url}
                        openInNewTab={true}
                    />
                    <Card
                        cardList={proSettings}
                        cardPlace='cw-pro'
                        cardCol='two-col'
                    />
                    <div className="cw-button">
                        <a href={cw_dashboard?.get_pro} target="_blank" className="cw-button-btn primary-btn long-button">{__('Learn more about the Pro version', 'vandana-lite')}</a>
                    </div>
                </div>
                <Sidebar sidebarSettings={sidebarSettings} openInNewTab={true} />
            </div>
        </>
    );
}

export default Homepage;