import { Icon, Card } from "../../components";
import { __ } from "@wordpress/i18n";
import { mainDemo, demo2, demo3, demo4, demo5, demo6 } from "../../components/images";

const StarterSites = () => {
    const cardList = [
        {
            heading: __('Default', 'vandana-lite'),
            imageurl: mainDemo,
            buttonUrl: __('https://blossomthemesdemo.com/vandana/', 'vandana-lite'),
        },
        {
            heading: __('Health Coach', 'vandana-lite'),
            imageurl: demo2,
            buttonUrl: __('https://blossomthemesdemo.com/vandana-health/', 'vandana-lite'),
        },
        {
            heading: __('Speaker', 'vandana-lite'),
            imageurl: demo3,
            buttonUrl: __('https://blossomthemesdemo.com/vandana-speaker/', 'vandana-lite'),
        },
        {
            heading: __('Life Coach', 'vandana-lite'),
            imageurl: demo4,
            buttonUrl: __('https://blossomthemesdemo.com/vandana-life-coach/', 'vandana-lite'),
        },
        {
            heading: __('Marriage Coach', 'vandana-lite'),
            imageurl: demo5,
            buttonUrl: __('https://blossomthemesdemo.com/vandana-marriage-coach/', 'vandana-lite'),
        },
        {
            heading: __('Entrepreneur', 'vandana-lite'),
            imageurl: demo6,
            buttonUrl: __('https://blossomthemesdemo.com/vandana-entrepreneur/', 'vandana-lite'),
        }
    ]
    return (
        <>
            <Card
                cardList={cardList}
                cardPlace='starter'
                cardCol='three-col'
            />
            <div className="starter-sites-button cw-button">
                <a href={__('https://blossomthemes.com/theme-demo/?theme=vandana&utm_source=vandana-lite&utm_medium=dashboard&utm_campaign=theme_demo', 'vandana-lite')} target="_blank" className="cw-button-btn outline">
                    {__('View All Demos', 'vandana-lite')}
                    <Icon icon="arrowtwo" />
                </a>
            </div>
        </>
    );
}

export default StarterSites;